<?php 
$emp_id = $_GET['emp_id'];
include 'header.php';
include 'navbar.php';
include "includes/constants.php";
include "../functions/getIds.php";

if(isset($_GET['fromDate'])){
    $fromDate = $_GET['fromDate'];
    $toDate = $_GET['toDate'];
}else{
    $fromDate = date('Y-m-01');
    $toDate = date('Y-m-d');
}

$monthStartDate =  $fromDate;
$monthEndDate =  $toDate;  
$period = getDatesFromRange($monthStartDate, $monthEndDate);  

$noOfDays = count($period);
if($noOfDays > 31){
    $error = true;
}else{
    $error = false;
}

$user = $emp_id;
$query1="SELECT region FROM `tbl_employee` WHERE eid= '$user'";
$result1 =mysqli_query($con,$query1);
$data1 = mysqli_fetch_assoc($result1);
$empRegion = $data1['region'];

function getDatesFromRange($start, $end, $format = 'Y-m-d') {
    $array = array();
    $interval = new DateInterval('P1D');

    $realEnd = new DateTime($end);
    $realEnd->add($interval);

    $period = new DatePeriod(new DateTime($start), $interval, $realEnd);

    foreach($period as $date) { 
        $array[] = $date->format($format); 
    }

    return $array;
}

?>
<style>
    .tab-block{
        height:155px;
        padding:8px;
    }
</style>
<nav class="navbar navbar-default head" style="display: block;">
    <div class="container-fluid meh">
        <div class="">            
             <a href="attendance-dashboard.php?emp_id=<?php echo $emp_id ?>" >
                <p class="heading" style="padding-top:0px;margin-bottom: -5px;color: white;font-size: 18px;"> &nbsp;&nbsp;&nbsp;
                    <i class="fas fa-arrow-left"></i> &nbsp;&nbsp;&nbsp;  Monthly Attendance &nbsp;&nbsp;&nbsp;&nbsp;
                </p> 
            </a> 
        </div>
    </div>
</nav>
<section class='m-t-80' style='margin-bottom:30px;'>
    <div class="container tab-block-section" style='margin-top:-20px;'>
        <br>
		<div class="row" style="margin-bottom:-10px">
		    <form method="get" action="<?php echo $_SERVER['PHP_SELF'] ?>">
		        <div class="col-xs-6">
    			    <label>From Date</label>
    				<input type="date" class="form-control" name="fromDate" value="<?php echo $fromDate ?>">
    			</div>
    			<div class="col-xs-6">
    			    <label>To Date</label>
    				<input type="date" class="form-control" name="toDate" value="<?php echo $toDate ?>">
    				<input type="hidden" class="form-control" name="emp_id" value="<?php echo $emp_id ?>">
    			</div>
    			<div class="col-xs-12 text-center">
    				<input type="submit" class="btn btn-primary submit-btn" name="submit" value="Submit" style="margin-top:0px;width:160px">
    			</div>
		    </form>
		</div>
		<hr>
		<?php
		    if($error == true){
		        echo '<div class="alert alert-warning" role="alert" style="color: #d57a2a;">
                      <i class="glyphicon glyphicon-warning-sign"></i>&nbsp;&nbsp; Date range must be within 31 days.
                    </div>';
		    }else{
	    ?>
	    <div class="table-responsive">
	        <table class="table table-bordered">
	            <thead>
                    <tr>
                        <th>SN</th>
                        <th>Employee Name</th>
                        <th>Mobile No</th>
                        <th>Designation</th>
                        <th>Region</th>
                        <?php
                                                          
                            foreach ($period as $key => $value) {
                                    $timestamp = $value;
                                // $timestamp = strtotime($year . '-' . $month . '-' . $i);
                                echo "<th width='2%'>" .date('d', strtotime($timestamp)).' ' . date('D', strtotime($timestamp)) . "</th>";
                            }
                            
                        ?>
                        <th width='5%'><i style='color:green;'>Present</i></th>
                        <th width='5%'><i style='color:orange;'>Leave</i></th>
                        <th width='5%'><i style='color:red;'>Absent</i></th>
                    </tr>
                </thead>

                <tbody>
                    <?php
                    $j = 1;
                    $rid = getRegionId($con,$empRegion);
                    $query = "SELECT *,
                                (SELECT designationName FROM tbl_designation WHERE designationId = t1.empDesignation) as empDesignationName,
                                (SELECT category_name FROM tbl_category WHERE category_id = t1.region) as regionName 
                            FROM 
                                tbl_employee t1 
                            WHERE 
                                region IN ($rid) 
                            AND 
                                (deleteflag = '0' OR `deleteDate` >= '$fromDate') 
                            AND user_role = 'employee'";
                    $result = $con->query($query);
                    while ($data = $result->fetch_assoc()) {
                        $presentCount = 0;
                        $absentCount = 0;
                        $leaveCount = 0;
                        $uk = 0;
                        $presentDate = array();
                        $leaveDate = array();
                        $lateLoginDate = array();
                        $presentDate = fetchEmployeePresentDate($con,$data['id'], $fromDate, $toDate);
                        $leaveDate = fetchEmployeeLeaveDate($con,$data['id'], $fromDate, $toDate);
                        $lateLoginDate = fetchEmployeeLateLoginDate($con,$data['id'], $fromDate, $toDate);
                        
                        //print_r($presentDate);
                        $eid = $data['id'];
                    ?>
                        <tr>
                            <td width='5%'><?php echo $j++; ?></td>
                            <td width='20%'><?php echo $data['emp_name']; ?></td>
                            <td width='20%'><?php echo $data['emp_mobile']; ?></td>
                            <td width='20%'><?php echo $data['empDesignationName']; ?></td>
                            <td width='20%'><?php echo $data['regionName']; ?></td>
                            <?php
                            foreach ($period as $key => $value) {
                                $cur_date = $value;   
                                unset($arrayId);
                                $weekDay = date('w', strtotime($cur_date));
                                $arrayId = array_search($cur_date, $presentDate);

                            ?>
                                <td style="text-align:center">
                                    <?php
                                    if ($arrayId === FALSE) {  
                                        if ($weekDay != 0) {
                                            $leaveArrayId = "";
                                            $leaveArrayId = array_search($cur_date, $leaveDate);
                                            if ($leaveArrayId === FALSE) {
                                                $absentCount++;
                                                echo "<b style='color:red;'>A</b>";
                                            } else {
                                                $leaveCount++;
                                                echo "<b style='color:orange;'>L</b>";
                                            }
                                        } else {
                                            echo "<b style='color:black;'>H</b>";
                                        }
                                        
                                    } else {
                                        if ($weekDay != 0) {
                                            $presentCount++;
                                        }
                                        $lateLoginArrayId = "";
                                        $lateLoginArrayId = array_search($cur_date, $lateLoginDate);
                                        if ($lateLoginArrayId === FALSE) {
                                            echo "<b style='color:green;'>P</b>";
                                        } else {
                                            echo "<b style='color:red;'>P</b>";
                                        }
                                    }
                                    ?>
                                </td>
                            <?php } ?>
                            <td width='2%' style="text-align:center"><?php echo $presentCount; ?></td>
                            <td width='2%' style="text-align:center"><?php echo $leaveCount; ?></td>
                            <td width='2%' style="text-align:center"><?php echo $absentCount; ?></td>

                        </tr>
                    <?php
                    } ?>
                </tbody>
            </table>
	    </div>
		<?php } ?>
        <br><br>
    
	</div>
</section>	
<?php include 'footer.php';?>
<script type="text/javascript">
        // <!-- Sending value to Android -->
    function showAndroidToast(toast) {
        // alert(toast);
        AndroidInterface.showBackPressButtonToast(toast);
    }       
</script>