<?php
include "includes/constants.php";

$regionIndex = $_REQUEST['regionIndex'];
$curDate = $_REQUEST['curDate'];

// Prepare the base query
$query = "SELECT t1.activityGeotag, t1.id, t1.eid, t2.emp_name 
          FROM tbl_track AS t1
          LEFT JOIN tbl_employee AS t2 ON t1.eid = t2.eid
          WHERE t1.date = '$curDate'
          AND t2.region IN ($regionIndex)";
//exit;
// Execute the query
//var_dump($con);
$result = $con->query($query);

$getDetails = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $getDetails[] = $row;
    }
}

$activity_name = [];
foreach ($getDetails as $empActDetail) {
    $activityGeotagForMarkerPosition = $empActDetail['activityGeotag'] ? explode('#', $empActDetail['activityGeotag']) : [];
    $empName = $empActDetail['emp_name'];
    
    foreach ($activityGeotagForMarkerPosition as $position) {
        $indVal = explode('/', $position);
        $activityName = '';
        $purpose = '';
        $villageName = '';
        $image = '';

        if ($indVal[3] == 0 || $indVal[3] == 20 || $indVal[3] == 10 || $indVal[3] == 11) {
            // Do nothing
        } else {
            $indVal4 = $indVal[4];
            if ($indVal[3] == 1) {
                $query = "SELECT t1.farmerName, t2.category_name, t1.farmerCity 
                          FROM tbl_farmer as t1 
                          LEFT JOIN tbl_category as t2 ON t2.category_id = t1.farmerRegion 
                          WHERE t1.farmerId = $indVal4";
                $result = $con->query($query);
                $ic = $result->fetch_assoc();
                
                $activityName = $ic ? $ic['farmerName'] : '';
                $purpose = 'IC';
                $villageName = $ic ? $ic['farmerCity'] : '';
                $image = '';
        
            } else if ($indVal[3] == 2) {
                $query = "SELECT t2.farmerName, t2.farmerCity, t1.SD_photo 
                          FROM tbl_farmactivity as t1 
                          LEFT JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId 
                          WHERE t1.faId = $indVal4";
                $result = $con->query($query);
                $sd = $result->fetch_assoc();
                
                $activityName = $sd ? $sd['farmerName'] : '';
                $purpose = 'SD';
                $villageName = $sd ? $sd['farmerCity'] : '';
                $image = $sd ? $sd['SD_photo'] : '';
        
            } else if ($indVal[3] == 3) {
                $query = "SELECT t2.farmerName, t2.farmerCity, t1.SDV_photo 
                          FROM tbl_farmactivity as t1 
                          LEFT JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId 
                          WHERE t1.faId = $indVal4";
                $result = $con->query($query);
                $sdv = $result->fetch_assoc();
                
                $activityName = $sdv ? $sdv['farmerName'] : '';
                $purpose = 'SDV';
                $villageName = $sdv ? $sdv['farmerCity'] : '';
                $image = $sdv ? $sdv['SDV_photo'] : '';
        
            } else if ($indVal[3] == 4) {
                $query = "SELECT t2.farmerName, t2.farmerCity, t1.fd_image 
                          FROM tbl_farmactivityFD as t1 
                          LEFT JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId 
                          WHERE t1.fafdId = $indVal4";
                $result = $con->query($query);
                $fd = $result->fetch_assoc();
                
                $activityName = $fd ? $fd['farmerName'] : '';
                $purpose = 'FD';
                $villageName = $fd ? $fd['farmerCity'] : '';
                $image = $fd ? $fd['fd_image'] : '';
        
            } else if ($indVal[3] == 5) {
                $query = "SELECT villageNameID, fmPhoto 
                          FROM tbl_farmermeeting 
                          WHERE fmId = $indVal4";
                $result = $con->query($query);
                $fm = $result->fetch_assoc();
                
                $activityName = $fm ? $fm['villageNameID'] : '';
                $purpose = 'FM';
                $villageName = '';
                $image = $fm ? $fm['fmPhoto'] : '';
        
            } else if ($indVal[3] == 6) {
                $query = "SELECT t2.agencyShopName, t2.agencyCity, t1.aVisitPhoto_key 
                          FROM tbl_agencyvisit as t1 
                          LEFT JOIN tbl_agency as t2 ON t1.agencyId = t2.agencyId 
                          WHERE t1.visitId = $indVal4";
                $result = $con->query($query);
                $av = $result->fetch_assoc();
                
                $activityName = $av ? $av['agencyShopName'] : '';
                $purpose = 'AV';
                $villageName = $av ? $av['agencyCity'] : '';
                $image = $av ? $av['aVisitPhoto_key'] : '';
        
            } else if ($indVal[3] == 7) {
                $query = "SELECT agencyShopName, agencyCity 
                          FROM tbl_agency 
                          WHERE agencyId = $indVal4";
                $result = $con->query($query);
                $newAg = $result->fetch_assoc();
                
                $activityName = $newAg ? $newAg['agencyShopName'] : '';
                $purpose = 'New agency';
                $villageName = $newAg ? $newAg['agencyCity'] : '';
                $image = '';
        
            } else if ($indVal[3] == 8) {
                $query = "SELECT t2.agencyShopName, t2.agencyCity, t1.img 
                          FROM tbl_ordernew as t1 
                          LEFT JOIN tbl_agency as t2 ON t1.did = t2.agencyId 
                          WHERE t1.oid = $indVal4";
                $result = $con->query($query);
                $order = $result->fetch_assoc();
                
                $activityName = $order ? $order['agencyShopName'] : '';
                $purpose = 'Order';
                $villageName = $order ? $order['agencyCity'] : '';
                $image = $order ? $order['img'] : '';
        
            } else if ($indVal[3] == 9) {
                $query = "SELECT t2.agencyShopName, t2.agencyCity, t1.payimg 
                          FROM tbl_payment as t1 
                          LEFT JOIN tbl_agency as t2 ON t1.dealerName = t2.agencyId 
                          WHERE t1.id = $indVal4";
                $result = $con->query($query);
                $payment = $result->fetch_assoc();
                
                $activityName = $payment ? $payment['agencyShopName'] : '';
                $purpose = 'Payment';
                $villageName = $payment ? $payment['agencyCity'] : '';
                $image = $payment ? $payment['payimg'] : '';
        
            } else if ($indVal[3] == 12) {
                $query = "SELECT t2.farmerName, t2.farmerCity, t1.photo 
                          FROM tbl_revisit as t1 
                          LEFT JOIN tbl_farmer as t2 ON t1.farmerId = t2.farmerId 
                          WHERE t1.rid = $indVal4";
                $result = $con->query($query);
                $revisit = $result->fetch_assoc();
                
                $activityName = $revisit ? $revisit['farmerName'] : '';
                $purpose = 'Revisit';
                $villageName = $revisit ? $revisit['farmerCity'] : '';
                $image = $revisit ? $revisit['photo'] : '';
            }
            if ($purpose) {
                $object = [
                    'activityType' => intval($indVal[3]),
                    'Purpose' => $purpose,
                    'activity_name' => $activityName,
                    'villageName' => $villageName,
                    'empName' => $empName,
                    'activity_time' => $indVal[2],
                    'image' => $image
                ];
                $activity_name[] = $object;
            }
        }

        
    }
}

// Sort the array as per activity_time
usort($activity_name, function($a, $b) {
    return strtotime($b['activity_time']) - strtotime($a['activity_time']);
});

$totalCount = count($activity_name);



$response = [
    'code' => 200,
    'data' => $activity_name,
   
];

header('Content-Type: application/json');
echo json_encode($response);

// Assuming this function exists for region ID retrieval
function getRegionId($regionIndex) {
    // Your implementation here to get region IDs
    return '1,2,3'; // Example return value
}

?>